; #######################################################################################
; #   RSX POUR LE DEUULIGNE DE AMSTRAD.EU   # PHILIPPE MOULIN # RETROPOKE #  01/06/2022	#
; #######################################################################################
; # |GPRINT, @a$ .............(AFFICHE LA CHAINE a$ A LA POSITION DU CURSEUR GRAPHIQUE)	#
; # |GPAS, PasX, PasY..........................(FIXE LE CRENAGE ENTRE CHAQUE CARACTERE) #
; # |GPEN, Crayon [, Papier] .........(SELECTION DE LA COULEUR D'ECRITURE ET DU PAPIER) #
; # |GMODE, [0 ou 1 ou 2 ou 3] ....(FILTRE GRAPHIQUE #0=NORMAL# #1=XOR# #2=AND# #3=OR#) #
; # |GFOND [0 ou 1].....(FIXE LA TRANSPARENCE DE L'ECRITURE #0=OPAQUE# #1=TRANSPARENT#) #
; #######################################################################################
; DECLARATION DES VARIABLES			; 					#
QUATRE_OCTETS 	EQU #BDF7			; EMPLACEMENT DES 4 OCTETS RESERVES RSX	#
; #######################################################################################
ORG #A400 					; #A400=DEBUT #A474=FIN      116 OCTETS #
; #######################################################################################
FIXE_RSX 					; IMPLANTATION DES RSX			#
	LD BC, ADR_NOM_RSX			; 'BC' POINTE SUR 2 OCTETS ADR. NOM RSX	#
	LD HL, QUATRE_OCTETS			; 'HL' POINTE SUR 4 OCTETS DE LIBRE	#
	JP #BCD1				; VECTEUR QUI FIXE LES RSX		#
						; 					#
   ADR_NOM_RSX	DW NOM_RSX			; POINTE SUR L'ADRESSE DES NOMS DES RSX #
        	JP RSX_GPRINT			; AFFICHE UN TEXTE A LA POSITION GRAPH.	#
		JP RSX_GPAS			; PAS X ET Y ENTRE LES LETTRES 		#
		JP RSX_GPEN			; COULEUR ENCRE ET PAPIER GRAPHIQUE	#
		JP RSX_GMODE			; FILTRE 0=NORMAL 1=XOR 2=AND 3=OR	#
		JP RSX_GFOND			; FOND GRAPHIQUE NORMAL OU TRANSPARENT	#
						;					#
   NOM_RSX	STR "GPRINT"			; |SPRINT, @A$				#
		STR "GPAS"			; |GPAS, PAS X, PAS Y			#
		STR "GPEN"			; |GPEN, PEN [, PAPER]			#
		STR "GMODE"			; |GMODE, [0, 1, 2 OU 3]		#
		STR "GFOND"			; |GFOND, [0 OU 1]			#
		DB 00				; LA LISTE DOIT FINIR PAR UN OCTET ZERO #
; #######################################################################################

; #######################################################################################
RSX_GPRINT					; |GPRINT, @A$				#
 	EX HL, DE				; 'HL'= ADR. DU DESCRIPTEUR DE CHAINE	#
	LD A, (HL)				; 'A'= NOMBRE DE CARACTERE DE LA CHAINE	#
	OR A					; SI LA CHAINE EST VIDE	ON SORT		#
	RET Z					;					#
	LD B, A					; 'B' SERA UTILISE POUR DECOMPTER LA	#
	INC HL					; LONGUEUR DE LA CHAINE			#
	LD E, (HL)				;					#
	INC HL					;					#
	LD D, (HL)				; 'DE' POINTE SUR LE PREMIER CARACTERE	#
						;					#
FAIRE_TOUTE_LA_CHAINE				;					#
    PUSH BC					; 'B'=NOMBRE DE CARACTERES		#
	LD A, (DE)				; 'DE'=ADRESSE DES CARACTERES		#
	INC DE					;					#
    PUSH DE					;					#
	CALL #BBFC				; AFFICHER CARACTERE POSITION GRAPHIQUE #
    AXE_X	LD DE, #0000			; DEPLACER LE CURSEUR GRAPHIQUE		#
    AXE_Y	LD HL, #0004			; 'DE'=PAS X     'HL'=PAS Y		#
	CALL #BBC3				; VECTEUR [MOVER] 			#
    POP DE					; RECUPERE LA CHAINE			#
    POP BC					; ET LE NOMBRE DE CARACTERE		#
	DJNZ, FAIRE_TOUTE_LA_CHAINE		; ET ON RECOMMENCE JUSQU'AU DERNIER	#
	RET					; CARACTERE DE LA CHAINE		#
; #######################################################################################

; #######################################################################################
RSX_GPAS					; |GPAS, PAS X, PAS Y			#
	LD (AXE_Y + 1), DE			; INSCRIRE LE PAS Y			#
	LD H, (IX + 3)				; 'DE'= PAS Y				#
	LD L, (IX + 2)				; 'HL'= PAS X				#
	LD (AXE_X + 1), HL			; INSCRIRE LE PAS X			#
	RET					; ET TERMINER 				#
; #######################################################################################

; #######################################################################################
RSX_GPEN					; |GPEN, CRAYON [, PAPIER] 		#
	DEC A					; REGARDER SI LE PAPIER EST ENVOYE	#
	JR Z, QUE_PEN				; NON IL N'Y A QUE LE CRAYON		#
	LD A, E					; OUI ALORS CHARGER LA VALEUR DANS 'A'	#
	CALL #BBE4				; ET APPELER LE VECTEUR GRAPHIC_PAPER	#
	LD E, (IX + 2)				; PUIS METTRE LE CRAYON DANS 'E'	#
						;					#
    QUE_PEN					; 					#
	LD A, E					; CHARGER LE CRAYON DANS 'A'		#
	JP #BBDE				; ET APPELER LE VECTEUR GRAPHIC_PEN	#
; #######################################################################################

; #######################################################################################
RSX_GMODE					; |GMODE, MODE [0, 1, 2 OU 3]		#
	LD A, E					; 'A'= (0=NORMAL 1=XOR 2=AND 3=OR)	#
	JP #BC59				; VECTEUR SELECTION DU MODE GRAPHIQUE	#
; #######################################################################################

; #######################################################################################
RSX_GFOND					; |GFOND, [0 OU 1]			#
	LD A, E					; 'A'= (0=NORMAL 1=TRANSPARENT)		#
	JP #BB9F				; VECTEUR SELECTION DU FOND GRAPHIQUE	#
; #######################################################################################
FIN
END
