; #######################################################################################
; # RETROPOKE.CANALBLOG.COM #### Philippe Moulin ##### DEBUT 08/06/2020  MAJ 05/07/2020 #
; # RSX COMPATIBLE AVEC LES TROIS MODES DE L'AMSTRAD ET SUR TOUS LES CPC (464,664,6128)	#
; #######################################################################################
;;# TEXTE$="MON TEXTE": |SPRINT [,INDICATEUR], TEXTE$					#
; # - INDICATEUR EST OPTIONNEL. S'IL EST OMIS, IL CONSERVERA LA DERNIERE VALEUR 	#
; #	INDICATEUR BIT 0 (VALEUR 1)	= ROTATION 90 DEGRES				#
; #	INDICATEUR BIT 1 (VALEUR 2)	= ROTATION VERTICALE (HAUT BAS)			#
; #	INDICATEUR BIT 2 (VALEUR 4)	= ROTATION HORIZONTALE (GAUCHE DROITE)		#
; #	INDICATEUR BIT 3 (VALEUR 8)	= DOUBLE LARGEUR				#
; #	INDICATEUR BIT 4 (VALEUR 16)	= DOUBLE HAUTEUR				#
; #	INDICATEUR BIT 5 (VALEUR 32)	= AFFICHAGE VERTICAL				#
; # - VOUS POUVEZ COMBINER PLUSIEURS BIT'S POUR PLUSIEURS EFFETS A LA FOIS		#
;;#	EXEMPLE>>> T$="MON TEXTE": |SPRINT, 1 + 8 + 32, @T$				#
; #	AFFICHERA LE TEXTE VERTICALEMENT AVEC ROTATION DE 90 DEGREE EN DOUBLE LARGEUR 	#
; #     LE @ (A accent) DEVANT LA CHAINE EST OBLIGATOIRE SUR LES CPC 464		#
; #######################################################################################
PILE 	EQU #BDF7				; ADRESSE PROVISOIRE DES MATRICES	#
ORG #A300					; PEUT ETRE DEPLACE AVANT COMPILATION	#
FIXE_RSX					;					#
; ########## MISE EN PLACE DU RSX SPRINT ######	;					#
	LD A, #C9				; ON EMPECHE DE LANCER PLUSIEURS FOIS   #
	LD (FIXE_RSX), A			; 'FIXE_RSX' POUR EVITER DES PLANTAGES 	#
	LD HL, QUATRE_OCTETS			; 'HL' POINTE SUR 4 OCTETS VIDE		#
	LD BC, ADR_NOM_RSX			; 'BC' POINTE SUR 2 OCTETS CONTENANT 	#
						; L'ADRESSE DES NOMS DES RSX		#
	JP #BCD1				; VECTEUR QUI FIXE LES RSX		#
						;					#
   ADR_NOM_RSX	DW NOM_RSX			; POINTE SUR L'ADRESSE DES NOMS DES RSX #
        JP RSX_SPRINT				; LISTE DES SAUTS VERS LES RSX		#
						;					#
   NOM_RSX	STR "SPRINT"			; LISTE DES NOMS DONNES AUX RSX		#
	DB 00					; LA LISTE DOIT FINIR PAR UN OCTET ZERO #
						;					#
   QUATRE_OCTETS DS 4				; EMPLACEMENT DES 4 OCTETS RESERVES	#
RSX_SPRINT 					;					#
; ########## DEBUT DU PROGRAMME ###############	; #####################################	#
	DEC A					; 1 PARAMETRE DE TRANSMIS ?	 	#
	JR Z, SANS_PARAMETRE_INDICATEUR		; OUI 					#
	DEC A					; 2 PARAMETRES MAXI			#
	RET NZ					; SINON HORS JEU			#
	LD A, (IX + 2)				; 'A' CONTIENT L'INDICATEUR		#
	LD (SPRINT_INDIC + 1), A		; ON L'INSCRIT DANS L'EMPLACEMENT PREVU #
						;					#
   SANS_PARAMETRE_INDICATEUR			;					#
	EX HL, DE				; 'HL'= DESCRIPTEUR DE CHAINE		#
	LD A, (HL)				; 'A'= NOMBRE DE CARACTERE		#
	OR A					; SI ZERO, ON SORT SINON PLANTAGE 	#
	RET Z					;					#
	INC HL					; 					#
	LD E,(HL)				;					#
	INC HL					;					#
	LD D,(HL)				; 'DE' POINTE SUR LE 1er CARACTERE	#
						;					#
	LD B, A					; C'EST 'B' QUI SERVIRA DE BOUCLE	#
   FAIRE_TOUS_LES_CARACTERES			; POUR AFFICHER TOUS LES CARACTERES	#
	LD A, (DE)				; 'A' CONTIENDRA LES CARACTERES	DE LA	#
    PUSH DE					; CHAINE (UN PAR UN)			#
    PUSH BC					;					#
	CALL #BBA5				; 'HL' = ADR DE LA MATRICE DU CARACTERE	#
	CALL #B906				; QUI SE TROUVE DANS LA ROM AMSTRAD	#
	LD BC, #08				; ON RECUPERE LES 8 OCTETS DU CARACTERE #
	LD DE, PILE				; ET ON LES COPIE POUR LES MANIPULER	#
   PUSH DE					;					#
	LDIR					; TRANSFERT EFFECTUE			#
	CALL #B909				; ON FERME LA ROM AVANT DE POURSUIVRE	#								
   POP HL					; 'HL'= PILE				#
   PUSH HL					;					#
						;					#
   SPRINT_INDIC LD D, #00			; 'D' CONTIENT L'INDICATEUR		#
; ########## 90 DEGRES ########################	;					#
	BIT 0, D				; TESTER SI ON DOIT PIVOTER LE TEXTE	#
	JR Z, DEGRES_OFF			; NON					#
   PUSH HL					; OUI ROTATION 90 DEGRES A FAIRE	#
   PUSH DE					; ON A BESOIN DE TOUS LES REGISTRES	#
	EX HL, DE				; 'DE'=PILE				#
	LD HL, PILE + 15			; 'HL' POINTE SUR LE DERNIER OCTET DU	#
	LD C, 8					; 2eme CARACTERE # 8 OCTETS A 90 DEGRES	#
						;					#
   DEGRES_LIGNE					;					#
   PUSH DE					; 					#
	LD B, 8					; 8 BITS PAR OCTET			#
						;					#
   DEGRES_BITS					;					#
	LD A, (DE)				; 'A' CONTIENT L'OCTET (BIT DE GAUCHE)	#
	RRA					; ON LE POUSSE VERS LA GAUCHE		# 
	RR (HL)					; ET ON RECUPERE LE BIT DANS 'HL'	# 
	LD (DE), A				; ON PASSE A L'OCTET SUIVANT		#
	INC DE					;					#
	DJNZ, DEGRES_BITS			; JUSQU'A FAIRE 8 BIT'S DE CHAQUE OCTET	#
   POP DE					; POUR OBTENIR UN OCTET 		#
	DEC HL					; ET ON DEGRESSE LES 8 OCTETS		#
	DEC C					;					#
	JR NZ, DEGRES_LIGNE			; ET PASSER TOUS LES BIT'S DES OCTETS	# 
	INC HL					; ON REVIENT SUR L'EMPLACELENT DU 2eme  #
	LD BC, 8				; ON TRANSFERT LA MATRICE OBTENUE	#
	LDIR					; 					#
   POP DE					;					#
   POP HL					;					#
						;					#
   DEGRES_OFF					; 					#
; ########## ROTATION VERTICAL ################	;					#
	BIT 1, D				; EFFET VERTICAL ?			#
	JR Z, VERTICAL_OFF			; NON					#
   PUSH HL					; OUI, ON A BESOIN DES REGISTRES	#
   PUSH DE					;					#
	LD DE, PILE + 7				; ON VA INVERSER LES 4 PREMIERS OCTETS  #
	LD B, 4					; AVEC LES 4 DERNIERS EN SENS OPPOSE    #
						;					#
   VERTICAL_TOUT				;					#
	LD A, (DE)				; 'A'=DERNIER OCTET			#
	LD C, (HL)				; 'C'=PREMIER OCTET			#
	LD (HL), A				;					#
	LD A, C					; 'LD (DE), C'  N'EST PAS POSSIBLE	#
	LD (DE), A				;					#
	INC HL					;					#
	DEC DE					;					#
	DJNZ, VERTICAL_TOUT			;					#
   POP DE					;					#
   POP HL					;					#
						;					#
   VERTICAL_OFF					;					#
; ########## ROTATION HORIZONTAL ##############	;					#
	BIT 2, D				; ROTATION HORIZONTAL ?			#
	JR Z, NON_HORIZONTAL			; NON -> NON_HORIZONTAL			#
   PUSH HL					; OUI					#
	LD C, 8					; ON TRAITE 8 OCTETS PAR CARACTERE	#
						;					#
   ROT_GD_LIGNE					;					#
	LD A, (HL)				; A CONTIENT L'OCTET 			#						;
	LD B, 8					; FAIRE UNE ROTATION DE 8 BIT'S PAR	#
						; OCTET					#
   ROT_GD_BITS					;					#
	RLA					; ON POUSSE L'OCTET VERS LA DROITE	#	
	RR (HL)					; ET ON LE RECUPERE PAR LA GAUCHE >'HL' #
	DJNZ, ROT_GD_BITS 			;					#
						;					#
	INC HL					;					#
	DEC C					;					#
	JR NZ, ROT_GD_LIGNE			; JUSQU'AU DERNIER OCTET		#
   POP HL					;					#
						;					#
   NON_HORIZONTAL				;					#
; ########## DOUBLE LARGEUR ###################	;					#
	BIT 3, D				; TESTER SI DOUBLE LARGEUR		#
	JR Z, NON_DOUBLE_LARGEUR		; NON					#
   PUSH HL					; OUI, ON TRAVAILLERA SUR 2 MATRICES	#
   PUSH DE					;					#
	LD DE, PILE + 8				; 'DE' = 2eme MATRICE			#
	LD C, 8					; TOUT LES OCTETS DU SYMBOL 		#
						; SERONT TRAITES			#
   DOUBLE_TOUT					;					#
	LD A, (HL)				; 'A' CONTIENT LES OCTETS		#
	EX HL, DE				; 'HL' POINTE SUR LA 2eme MATRICE	#
	LD B, 4					; ON VA PASSER 4 BITS SUR UN OCTET	#
						;					#
   DOUBLE_GAUCHE				;					#
	RRA					; ON GLISSE CHAQUE BIT DE L'OCTET	#
	RR (HL)					; QUE L'ON COPIE DAND 'HL'		#
	SRA (HL)				; EN DEUX FOIS DE SUITE			#
	DJNZ, DOUBLE_GAUCHE			; LE 2eme OCTET ET FINI			#
	EX HL, DE				; ON COPIE LES 4 BITS RESTANT DANS	#
	LD B, 4					; LA 1ere MATRICE			#
						;					#
   DOUBLE_DROITE				;					#
	RRA					; ON PROCEDE DE LA MEME FACON		#
	RR(HL)					; ON DUPLICATE LE BIT			#
	SRA (HL)				; ET ON LE DOUBLE			#
	DJNZ, DOUBLE_DROITE			; TOUT CA POUR UN OCTET			#
	INC HL					; IL Y EN A 8 A FAIRE			#
	INC DE					;					#
	DEC C					;					#
	JR NZ, DOUBLE_TOUT			;					#
   POP DE					;					#
   POP HL					;					#
						;					#
   NON_DOUBLE_LARGEUR				;					#
; ########## DOUBLE HAUTEUR ###################	;					#
	BIT 4, D				; TESTER SI DOUBLE HAUTEUR		#
	JR Z, NON_DOUBLE_HAUTEUR		; NON					#
   PUSH HL					; OUI, ON TRAVAILLERA SUR 2*2 MATRICES	#
   PUSH DE					; EN PARTANT DE LA FIN VERS LE DEBUT	#
	LD DE, PILE + 23			; 'DE' = FIN DE LA 3eme MATRICE		#
	LD HL, PILE + 7				; 'HL' = FIN DE LA PREMIERE MATRICE	#
						;					#
	LD C, 2					; IL FAUT DOUBLER LES 2 MATRICES POUR	#
   FAIRE_DEUX_MATRICE				; LA DOUBLE LARGEUR + DOUBLE HAUTEUR	#
	LD A, 4					; POSITIONNERA 'DE' ENTRE 2 MATRICES	#
						; IL FAUT SAUTER 1 MATRICE DE LARGE	#
	LD B, 8					; FAIRE TOUS LES OCTETS DU CARACTERE	#
   DOUBLE_HAUTEUR_UNE_MATRICE			;					#
   PUSH BC					; ON COPIERA 2 FOIS (HL) VERS (DE)  	#
	LDD					; (DE) = (HL)				#
	INC HL					; ON REVIENT SUR LA VALEUR DE (HL)	#
	LDD					; (DE) = (HL)				#
	DEC A					; LE REGISTRE 'A' EST LA POUR CHANGER	#
	JR NZ, MATRICE_DE			; LA MATRICE DE 'DE' 			# 
	LD B, 8					; EN DECREMENTANT 'DE' DE 8 OCTETS	#
						;					#
   SAUTER_UNE_MATRICE				; PERMET DE PASSER DE LA MATRICE 3 A LA #
	DEC DE					; MATRICE 1				#
	DJNZ, SAUTER_UNE_MATRICE		;					#
						;					#
   MATRICE_DE					;					#
   POP BC					;					#
	DJNZ, DOUBLE_HAUTEUR_UNE_MATRICE	;					#
	LD HL, PILE + 15			; ON PASSE A LA SECONDE MATRICE QUI	#
	LD DE, PILE + 31			; CONSERNE LA DOUBLE LARGEUR		#
	DEC C					; AVEC LE MEME PROCEDE + 8 OCTETS	#
	JR NZ, FAIRE_DEUX_MATRICE		;					#
   POP DE					;					#
   POP HL					;					#
						;					#
NON_DOUBLE_HAUTEUR				; FIN DU TRAITEMENT DE LA MATRICE	#
; ########## AFFICHER LE CARACTERE ############ ;					#
   POP HL					; 'HL' = MATRICE			#
	CALL AFFICHER_LE_CARACTERE		; ON AFFICHE LE CARACTERE 255		#
	BIT 4, D				; ET ON REGARDE SI IL FAUT AFFICHER LA 	#
	JR Z, DOUBLE_LARGEUR			; 3eme MATRICE POUR LA DOUBLE HAUTEUR	#
	LD A, 8					; OUI ALORS IL FAUT D'ABORD DEPLACER LE	#
	CALL #BB5A				; CURSEUR EN DESSOUS DU 1er CARACTERE	#
	LD A, 10				;					#
	CALL #BB5A				;					#
	LD HL, PILE + 16			; ON INDIQUE QU'IL S'AGIT DE LA 3eme	#
	CALL AFFICHER_LE_CARACTERE		; MATRICE ET ON L'AFFICHE		#
	LD A, 11				; ON PLACE LE CURSEUR SUR LE CARACTERE	#
	CALL #BB5A				; SUIVANT				#
						;					#
   DOUBLE_LARGEUR				;					#
	BIT 3, D				; EST-QU'IL FAUT AFFICHER EN DOUBLE	#			
	JR Z, HAUTEUR_OFF			; LARGEUR ?				#
	LD HL, PILE + 8				; OUI, ON POINTE 'HL' VERS LA MATRICE	# 
	CALL AFFICHER_LE_CARACTERE		; ET ON L' AFFICHE			#
	BIT 4, D				; REGARDER SI ON EST EN DOUBLE HAUTEUR	#
	JR Z, HAUTEUR_OFF			; NON					#
	LD A, 8					; OUI, ON DEPLACE LE CURSEUR EN DESSOUS	#
	CALL #BB5A				;					#
	LD A, 10				;					#
	CALL #BB5A				;					#
	LD HL, PILE + 24			; ON POINTE 'HL' VERS LA MATRICE 	#
	CALL AFFICHER_LE_CARACTERE		; CONCERNEE				#
	LD A, 11				; ET ON REPOSITIONNE LE CURSEUR		#
	CALL #BB5A				;					#
						;					#
HAUTEUR_OFF					;					#
; ########## AFFICHAGE VERTICAL ###############	;					#
	BIT 5, D				; AFFICHAGE VERTICAL ?			#
	JR Z, AFFICHAGE_SIMPLE_HAUTEUR		; NON, ON POURSUIT AU CARACTERE SUIVANT	#
	LD A, 8					; OUI, IL FAUT DEPLACER LE CURSEUR EN 	#
	CALL #BB5A				; TENANT COMPTE DE LA DOUBLE HAUTEUR ET	#
	BIT 3, D				; DE LA DOUBLE LARGEUR			#
	JR Z, AFFICHAGE_SIMPLE_LARGEUR		;					#
	CALL #BB5A				;					#
						;					#
   AFFICHAGE_SIMPLE_LARGEUR			;					#
	LD A, 10				; 					#
	CALL #BB5A				;					#
	BIT 4, D				; 					#
	JR Z, AFFICHAGE_SIMPLE_HAUTEUR		; 					#
	CALL #BB5A				; 					#
						; 					#
AFFICHAGE_SIMPLE_HAUTEUR			;					#
; ########## FIN DU TRAITEMENT DU CARACTERE ### ;					#
   POP BC					;					#
   POP DE					;					#
	INC DE					; ON PASSE TOUS LES CARACTERES DE LA	#
	DEC B					; CHAINE UN PAR UN			#
	JP NZ, FAIRE_TOUS_LES_CARACTERES	; 					#
	RET					; ET ON TERMINE LA PROCEDURE 		#
; ############################################# ; ##################################### #
AFFICHER_LE_CARACTERE				;					#
; ########## SOUS ROUTINE SYMBOL ET PRINT ##### ;					#
  PUSH DE					; SAUVER 'D' QUI SERT D'INDICATEUR	#
	XOR A					; EFFACER 'A' ( 'A' = 0 )		#
	DEC A					; EQUIVAUT A 'LD A, #FF' EN PLUS RAPIDE #
	CALL #BBA8 				; VECTEUR SYMBOL 255,xx,xx,xx... ...	#
	XOR A					; LES REGISTRE SONT HS			#
	DEC A					; EQUIVAUT A 'LD A, #FF' EN PLUS RAPIDE #
	CALL #BB5A				; VECTEUR PRINT CHR$(255)		#
   POP DE					;					#
	RET					;					#
; #######################################################################################
