; ###############################################################################
;  DECOMPACTEUR DE ZONE D'ECRAN - PHILIPPE MOULIN - LE 01/08/2020 MAJ 10/08/2020#
; 	DECOMPACTE UNE ZONE OU D'UN ECRAN A L'ENDROIT INDIQUE EN PARAMETRE	# 
;	      ROUTINE POUR EVITER LES PLANTAGES EN CAS DE DEBORDEMENT		#
;		CE PROGRAMME S'ACCOMPAGNE DU FICHIER "ZIPECRAN.ASM"		#
; ###############################################################################
SOURCE		EQU #BDF9		; PAR DEFAUT #C000 ECRAN		#
LARG_HAUT	EQU #BDFD		; PAR DEFAUT #50C9 COL, LIG		#
; ###############################################################################
ORG #A400				;					#
INIT_RSX				; INITIALISER LES RSX			#
	LD HL, QUATRE_OCTETS		; 'HL' POINTE SUR 4 OCTETS VIDE		#
	LD BC, ADR_NOM_RSX		; 'BC' POINTE SUR 2 OCTETS CONTENANT 	#
					; L'ADRESSE DES NOMS DES RSX		#
	JP #BCD1			; VECTEUR QUI FIXE LES RSX		#
					;					#
   ADR_NOM_RSX	DW NOM_RSX		; POINTE SUR L'ADRESSE DES NOMS DES RSX #
        JP RSX_DEZIP			; LISTE DES SAUTS VERS LES RSX		#
					;					#
   QUATRE_OCTETS DS 4			; EMPLACEMENT DES 4 OCTETS RESERVES	#
   NOM_RSX	STR "DEZIP"		; LISTE DES NOMS DONNES AUX RSX		#
	DB 00				; LA LISTE DOIT FINIR PAR UN OCTET ZERO #
					;					#
; ###############################################################################
ERREUR					;					#
	LD A, 7				;  EMMETRE UN SIMPLE BEEP D'ERREUR	#
	CALL #BB5A			;					#
	RET				;					#
; ###############################################################################
RSX_DEZIP				; DECOMPACTEUR SANS LES IMAGES		#
	CP 4				; 0 OU 1 OU 3 PARAMETRES		#
	JR NC, ERREUR			; > 3					#
	CP 2				; 					#
	JR Z, ERREUR			; = 2					#
	EX HL, DE			; 'HL'= DERNIER PARAMETRE (ADR.IMAGE)	#
	OR A				; SI IL N'Y A PAS DE PARAMETRE		#
	JR NZ, IX_PAR_DEFAUT		; ALORS 'HL' CONTIENT #4000		#
	LD HL, #4000			; SINON 'HL'=DERNIER PARAMETRE ENVOYE	#
					;					#
   IX_PAR_DEFAUT			;					#
	LD E, (HL)			; RECUPERER LES DONNEES	INSCRITES EN	#
	INC HL				; DEBUT DU COMPACTAGE			#
	LD D, (HL)			; (ADR.ECRAN + LARG_HAUT + TOKEN)	#
	INC HL				;					#
	LD (ADR_ECRAN + 1), DE		; ADRESSE ECRAN INITIALISE		#
	LD E, (HL)			;					#
	INC HL				;					#
	LD D, (HL)			;					#
	INC HL				;					#
	LD (COL_LIG + 1), DE		; LARGEUR ET HAUTEUR INITIALISES	#
	LD B, A				;					#
	LD A, (HL)			; 					#
	INC HL				;					#
	LD (TOKEN_04 + 1), A		; TOKEN INITIALISE			#
	LD (ADR_IX + 2), HL		; SOURCE INITIALISEE			#
	INC IX				;					#
	INC IX				;					#
					;			 		#
   ADR_ECRAN	LD HL, #C000		; PAR DEFAUT, MODIF. PAR LES PARAMETRES	#
	LD A, B				;					#
	CP A, 3				; SI 0 OU 1 PARAMETRE			#
	JR NZ, INIT_VAR_OK 		; ON GARDE LES COL, LIG PAR DEFAUT	#
	LD H, 0				; ADAPTER LA POSITION DU CURSEUR	#
	LD A, (IX + 0)			;					#
	LD L, A				;					#
	CP A, 200			; POSITION Y (DE 0 A 199)		#
	JR NC, ERREUR			; > 200					#				
	LD D, H				; 'DE'=COL 'HL'=LIG			#
	LD A, (IX + 2)			;					#
	LD E, A				;					#
	CP A, 80			; POSITION X (DE 0 A 79)		#
	JR NC, ERREUR			; > 79					#
	CALL #BC11			; AJUSTER 'DE' EN FONCTION DU MODE	#
	ADD A, A			; 'A'=MODE x 2				#
					;					#
   AJUSTE_MODE				;					#
	SLA E				; MULTIPLIER 'DE' PAR 2-MODE0 4-MODE1	#
	RL D				; 8-MODE2 (de 0 a 639)			#
	SRL A				; DIVISER POUR MIEUX MULTIPLIER		#
	JR NZ, AJUSTE_MODE		;					#
	CALL #BC1D			; VECTEUR ADR. ECRAN			#
					;					#
   INIT_VAR_OK				;					#
   ADR_IX	LD IX, #4000		; PAR DEFAUT. (AUTO_MODIFIE)		#
   COL_LIG	LD BC, #50C9		; PAR DEFAUT. AUTO MODIF		#
	DEC C				; SUPPRIMER LE SURPLUS			#
	LD (SOURCE), HL			; SAUVEGARDER LES VARIABLES		#
	LD (LARG_HAUT), BC		;					#
					;					#
   PROG_DECOMP				;					#
	LD A, (IX)			; PRENDRE CHAQUE OCTET			#
	INC IX				;					#
					;					#
   TOKEN_04 CP A, #FF			;  (VALEUR INITIALISEE AU LANCEMENT)	#
	JR Z, OCTET_TOKEN		; FAIRE BOUCLE AVEC 'D' COMME COMPTEUR	#
	LD D, 1				; SINON DEFINIR LA BOUCLE A UN OCTET	#
	LD E, A				; ET CHARGER DANS 'E' L'OCTET		#
	JR INIT_DE			; ALLER VERS LA BOUCLE POUR UN OCTET	#
					; 					#
   OCTET_TOKEN				;					#
	LD E, (IX + 0) 			; RECUPERER LA VALEUR DE L'OCTET 	#
	INC IX				;					#
	LD D, (IX + 0)			; ET LE NOMBRE DE FOIS A REPETER	#
	INC IX				;					#
					; 					#
   INIT_DE				; 					#
	LD A, H				; EN CAS DE DEBORDEMENT, PLUTOT QUE DE	#
	CP A, #C0			; PLANTER L'AMSTRAD, J'AI OPTE POUR NE	#
	JR C, HORS_ECRAN		; PAS ECRIRE DANS LA MEMOIRE <#C000	#
	LD A, E				;					#
   MOD_IF 	NOP			; (HL)<AND=A6<OR=B6<XOR=AE CPL=2F NOP=0	#
	LD (HL), A			; AFFICHER L'OCTET 			#
	INC HL				; ET PASSER AU SUIVANT, MAIS SI ON	#
	DEC B				; ARRIVE EN FIN DE COLONNE, DESCENDRE	#
	JR NZ, HL_MOINS_UN		; L'ADR_ECRAN D'UNE LIGNE		#
					;					#
   HORS_ECRAN				;					#
	DEC C				; JUSQU'A CE QU'IL NE RESTE AUCUNE LIGNE#
	RET Z 				; DANS CE CAS, ON REND LA MAIN		#
	LD HL, (SOURCE)			; SINON ON REVIENT EN DEBUT DE COLONNE	#
	CALL #BC26			; ET ON DESCEND D'UNE LIGNE		#
	LD (SOURCE), HL			; ON SAUVE LE DEBUT DE COLONNE		#
	LD A, (LARG_HAUT + 1)		; ET ON RECUPER LA LARGEUR		#
	LD B, A				; DANS LE REGISTRE 'B'			#
					; 					#
   HL_MOINS_UN				; 					#
	DEC D				; ON DECREMENTE LE NOMBRE D'OCTETS 	#
	JR NZ, INIT_DE			; JUSQU'A CE QUE 'D'=0			#
	JR PROG_DECOMP			; SINON ON POURSUIT LE DECOMPACTAGE	#
					; JUSQU'A CE QUE 'BC'=0			#
	FIN				; FIN DU PROGRAMME A COPIER		#
; ###############################################################################