; ###############################################################################
;  COMPACTEUR DE ZONE D'ECRAN - PHILIPPE MOULIN - LE 01/08/2020 MAJ 10/08/2020	#
;  LES IMAGES PEUVENT ETRE COMPACTEES AVEC OU SANS LE DECOMPACTEUR EU PEUVENT	#
;  S'AFFICHER N'IMPORTE OU SUR L'ECRAN. COMPATIBLE DANS LES 3 MODES D'ECRAN !	#
;              CE PROGRAMME S'ACCOMPAGNE DU FICHIER "DEZIP.ASM			#
; ###############################################################################
DESTINATION	EQU #BDF7		; PAR DEFAUT #4000 LIBRE		#
SOURCE		EQU #BDF9		; PAR DEFAUT #C000 ECRAN		#
LONG		EQU #BDFB		; RESULTAT FIN_DESTINATION-DESTINATION	#
LARG_HAUT	EQU #BDFD		; PAR DEFAUT #50C9 COL, LIG		#
LG_DECOMPACTEUR	EQU FIN-DECOMPACTEUR	; LONGUEUR DU PROGRAMME DE DECOMPACTAGE #
TOKEN 		EQU #FF			; OCTET DE COMPARAISON			#
; ###############################################################################
ORG #A400				;					#
INIT_RSX				; INITIALISER LES RSX			#
	LD HL, QUATRE_OCTETS		; 'HL' POINTE SUR 4 OCTETS VIDE		#
	LD BC, ADR_NOM_RSX		; 'BC' POINTE SUR 2 OCTETS CONTENANT 	#
					; L'ADRESSE DES NOMS DES RSX		#
	JP #BCD1			; VECTEUR QUI FIXE LES RSX		#
					;					#
   ADR_NOM_RSX	DW NOM_RSX		; POINTE SUR L'ADRESSE DES NOMS DES RSX #
        JP RSX_ZIP			; LISTE DES SAUTS VERS LES RSX		#
        JP RSX_DEZIP			; LISTE DES SAUTS VERS LES RSX		#
        JP RSX_ZIPOP			; LISTE DES SAUTS VERS LES RSX		#
        JP RSX_ZIPLONG			; LISTE DES SAUTS VERS LES RSX		#
					;					#
   QUATRE_OCTETS DS 4			; EMPLACEMENT DES 4 OCTETS RESERVES	#
   NOM_RSX	STR "ZIP"		; LISTE DES NOMS DONNES AUX RSX		#
   		STR "DEZIP"		; LISTE DES NOMS DONNES AUX RSX		#
   		STR "ZIPOP"		; LISTE DES NOMS DONNES AUX RSX		#
   		STR "ZIPLONG"		; LISTE DES NOMS DONNES AUX RSX		#
	DB 00				; LA LISTE DOIT FINIR PAR UN OCTET ZERO #
					;					#
; ###############################################################################
RSX_ZIP					;					#
	CP A, 6				; CONTROLER LE NOMBRE DES PARAMETRES	#
	JP NC, ERREUR			; >5 ON RETOURNE AU BASIC		#
	BIT 1, A 			; SORTIR SI PARAMETRE =2 OU =3		#
	JP NZ, ERREUR			; IL RESTE 0,1,4 OU 5 PARAMETRES	#
	LD HL, #4000			; INITIALISER LA DESTINATION PAR DEFAUT	#
	BIT 0, A			; SAUF SI ON L'INDIQUE EN PARAMETRE 1,5 #
	JR Z, DESTINATION_OK		; SI LE NOMBRE DE PARAMETRES =0 OU =4	#
	EX HL, DE			; NOUVELLE DESTINATION DANS 'HL'	#
	INC IX				; SUPPRIMER LE DERNIER PARAMETRE DE 'IX'#
	INC IX				;					#
					;					#
    DESTINATION_OK			;					#
	LD (ADR_DESTINATION + 1), HL	; SERVIRA A CALCULER LA LONGUEUR TOTALE	#
	LD (ADR_IX + 2), HL		; ADR. PAR DEFAUT, SANS LE DECOMPACTEUR #
	LD HL, #C000			; INITIALISER LA SOURCE PAR DEFAUT	#
	LD BC, #50C9			; AINSI QUE LA LARGEUR ET HAUTEUR	#
	CP A, 4				; REGARDER SI ON DESIRE LES MODIFIER	#
	JR C, DEBUT_OK			; SINON ON POURSUIT PLUS LOIN		#
	LD D, 0				; ADAPTER LA POSITION DU CURSEUR POUR	#
	LD E, (IX + 6)			; TROUVER L'ADR. SUR L'ECRAN		#
	LD H, D				; 'DE'=COL	 			#
	LD L, (IX + 4)			; 'HL'=LIG				#
	LD A, (IX + 2)			; VERIFIER QUE LA COL+LARG<=80		#
	LD B, A				; 'B'=LARGEUR EN OCTET			#
	OR A				; EMPECHER  LES PLANTAGES DES BOUCLES	#
	JP Z, ERREUR			; EGALES A ZERO				#
	ADD A, E			; 'A'= COL+LARGEUR			#
	CP A, 81			; SI PLUS DE 80 DE LARGEUR		#
					;					#
					; ADRESSE RELAIS VERS ERREUR		#
	JP NC, ERREUR			; ON SORT				#
	LD A, (IX + 0)			; RECUPERER LA HAUTEUR			#
	OR A				; NE PAS FAIRE DE BOUCLE A ZERO		#
	JP Z, ERREUR			;					#
	LD C, A				;					#
	LD A, (IX + 4)			; 'L'=LIG				#
	LD L, A				;					#
	CP A, 200			; SI PLUS GRAND QUE L'ECRAN, ON SORT	#
	JP NC, ERREUR			;					#
	DEC C				; LA HAUTEUR DOIT ETRE < QUE LES LIGNES	#
	CP A, C				; SI LIG<HAUTEUR - 1			#
	JP C, ERREUR			; CA SORT DE L'ECRAN, ON QUITTE		#
	INC C				; REPOSITIONNE LA HAUTEUR		#
	INC C				; + LA VALEUR 0 QUI DOIT ETRE CALCULER	#
   PUSH BC				;					#
	CALL #BC11			; AJUSTER 'DE' EN FONCTION DU MODE	#
	ADD A, A			; 'A'=MODE x 2				#
					;					#
   CALCUL_MODE				;					#
	SLA E				; MULTIPLIER 'DE' PAR 2-MODE0 4-MODE1	#
	RL D				; 8-MODE2 (de 0 a 639)			#
	SRL A				; DIVISER POUR MIEUX MULTIPLIER		#
	JR NZ, CALCUL_MODE		;					#
	CALL #BC1D			; VECTEUR ADR. ECRAN 'HL'= ADR.ECRAN	#
   POP BC				;					#
					;					#
   DEBUT_OK				; 					#
	LD (SOURCE), HL			; UTILISER PAR LE COMPACTEUR		#
	LD (LARG_HAUT), BC		; UTILISER PAR LE COMPACTEUR		#
	LD (ADR_ECRAN + 1), HL		; UTILISER PAR LE DE-COMPACTEUR		#
	LD (COL_LIG + 1), BC		; UTILISER PAR LE DE-COMPACTEUR		#
   PUSH HL				; SAUVER LES DONNEES PUIS TRANFERER  	#
   PUSH BC				; LE DE-COMPACTEUR SI L'OPION EST ACTIF	#
	LD HL, (ADR_DESTINATION + 1)	; RECUPERER L'ORIGINE DE LA DESTINATION	#
	LD D, H				; 'PUSH HL'				#
	LD E, L				; 'POP DE'		EN MIEUX	#
					;					#
   AVEC_SANS_DECOMPACTEUR		; LE DECOMPACTEUR DOIT'IL ETRE INCLUS ? #
	JR AVEC_DECOMPACTEUR		; OUI PAR DEFAUT			#
					;					#
   AVEC_DECOMPACTEUR			;					#
	LD BC, 5			; IL FAUT SAUTER 5 OCTETS POUR QUR LE	#
	ADD HL, BC			; DE-COMPACTEUR RETROUVE LE DEPART	#
	LD BC, LG_DECOMPACTEUR		; 'BC'= LONGUEUR DU PROGRAMME DE DECOMP.#
	ADD HL, BC			; 'HL'= DESTINATION + LONGUEUR DECOMP.	#
	LD (ADR_IX + 2), HL		; L'INSCRIRE POUR LE DECOMPACTEUR	#
	LD HL, DECOMPACTEUR		; 'HL'= ADR. SOURCE DU DUCOMPACTEUR	#
	LDIR				; LE DECOMPACTEUR EST TRANSFERER	#
   SANS_DECOMPACTEUR			; DEVIATION POUR NE PAS L'INCLURE	#
   POP BC				; 'BC'= LARG_HAUT			#
   POP HL				; 'HL'= SOURCE (ECRAN)			#
	EX HL, DE			; ON INSCRIT SOIT AU DEBUT, SOIT APRES	#
	LD (HL), E			; LE DE-COMPACTEUR, LES VARIABLES 	#
	INC HL 				; UTILISEES DE L'IMAGE			#
	LD (HL), D			; DEPART ADR.ECRAN			#
	INC HL 				;					#
	LD (HL), C			; LARGEUR				#
	INC HL 				; 					#
	LD (HL), B			; HAUTEUR				#
	INC HL 				;					#
TOKEN_01 LD A, TOKEN			; VALEUR DU TOKEN			#
	LD (HL), A			;					#
	INC HL 				;					#
	EX DE, HL			;					#
	LD (DESTINATION), DE		; MEMORISER POUR LE COMPACTAGE		#
					;					#
COMPACTER_LES_OCTETS			;					#
  	LD D, 1				; COMPTEUR D'OCTETS EGAUX QUI SE SUIVENT#
	LD A, (HL)			; 'A'=OCTET A COMPARER			#
	LD E, A				; 'E' SERT A SAUVEGARDER L'OCTET	#
					;					#
   NB_OCTETS_EGAUX			;					#
	INC HL				; ON DOIT PASSER AU SECOND OCTET MAIS	#
	DEC B				; SI ON EST EN FIN DE COLONNE, IL FAUT	#
	JR NZ, PAS_DESCENDRE_HL		; DESCENDRE D'UNE LIGNE			#
	DEC C				;					#
	JR Z, FIN_DE_COMPACTAGE		; ET SI IL N'Y EN A PLUS		#
	LD A, (LARG_HAUT + 1)		; IL FAUT REINITIALISER LA LARGEUR	#
	LD B, A				; PAR DEFAUT #50 (80 OCTETS		#
	LD HL, (SOURCE)			; PUIS DESCENDRE D'UNE LIGNE		#
	CALL #BC26			; J'UTILISE LE VECTEUR 			#
	LD (SOURCE), HL			; ON SAUVE L'EMPLACEMENT		#
	LD A, E				; ET ON RECUPERE L'OCTET A COMPARER	#
					;					#
   PAS_DESCENDRE_HL			;					#
	CP A, (HL)			; EST-CE QUE LES DEUX OCTETS SONT EGAUX?#
	JR NZ, INSCRIRE_DE		; NON ALORS ON SORT DE LA BOUCLE	#
	INC D				; OUI ALORS COMPTEUR + 1		#
	JR NZ, NB_OCTETS_EGAUX		; MAIS SI LE COMPTEUR DEPASSE 255	#
	DEC D				; ON LE RAMENE A 255			#
					;					#
   INSCRIRE_DE				;					#
   PUSH HL				;					#
	LD HL, (DESTINATION)		; ON RECUPERE LA DESTINEE		#
	LD A, E				; ET LA COULEUR				#
TOKEN_02 CP A, TOKEN 			; SI C'EST LA MEME VALEUR QUE LE TOKEN ?#
	JR Z, VOIR_PLUS_TOKEN		; ON INDIQUE QUE C'EST UNE BOUCLE AUSSI #
	LD A, D				; SINON ON REGARDE LE NOMBRE D'OCTETS 	#
	CP A, 1				; SI IL N'Y EN A QU'UN, ON L'INSCRIT 	#
	JR Z, INSCRIRE_EN_DEUX		; 					#
	CP A, 2				; SI IL N'Y EN A QUE DEUX, ON NE FAIT	#
	JR NZ, VOIR_PLUS		; PAS DE BOUCLE				#
	LD (HL), E 			; ET ON INSCRIT 1 FOIS LA COULEUR	#
	INC HL				;					#
					;					#
    INSCRIRE_EN_DEUX			; 					#
	LD (HL), E			; ON INSCRIT LA COULEUR			#
	JR INSCRIT			; PUIS ON SAUTE POUR CONTINUER		#
					;					#
   VOIR_PLUS				; POUR LES OCTETS DIFFERENTS AU TOKEN 	#
TOKEN_03 LD A, TOKEN			; IL FAUT RECUPERER LE TOKEN		#
					;					#
    VOIR_PLUS_TOKEN			;					#
	LD (HL), A 			; INSCRIRE LE TOKEN			#
	INC HL				;					#
	LD (HL), E 			; INSCRIRE L'OCTET DES COULEURS		#
	INC HL				;					#
	LD (HL), D 			; INSCRIRE LE NOMBRE DE FOIS		#
					;					#
    INSCRIT				;					#
	INC HL				; ON PASSE A DESTINATION + 1		#
	LD (DESTINATION), HL		; ET ON SAUVEGARDE			#
	POP HL				; ON RECUPERE LA SOURCE (ADR.ECRAN)	#
	JR COMPACTER_LES_OCTETS		; JUSQU'AU DERNIER OCTET		#
					;					#
    FIN_DE_COMPACTAGE			; ########## CALCULER_LONG 		#
ADR_DESTINATION	LD DE, #4000		; RECUPERER L'ADRESSE DU DEBUT		#
	LD HL, (DESTINATION)		; ET L'ADRESSE FINALE			#
	SBC HL ,DE			; 'HL=HL-DE'				#
	INC HL				; + 1					#
	LD (LONG), HL			; INSCRIRE LE RESULTAT FINAL		#
	RET				; COMPILATION TERMINEE			#
; ###############################################################################
ERREUR					;					#
	LD HL, 0			; METTRE LA LONGUEUR A ZERO		#
	LD (LONG), HL			; 					#
	LD A, 7				; ET EMMETRE UN SIMPLE BEEP D'ERREUR	#
	CALL #BB5A			;					#
	RET				;					#
; ###############################################################################
RSX_DEZIP				; DECOMPACTEUR SANS LES IMAGES		#
	CP 4				; 0 OU 1 OU 3 PARAMETRES		#
	JR NC, ERREUR			; > 3					#
	CP 2				; 					#
	JR Z, ERREUR			;					#
	EX HL, DE			; 'HL'= DERNIER PARAMETRE (ADR.IMAGE)	#
	OR A				; SI IL N'Y A PAS DE PARAMETRE		#
	JR NZ, IX_PAR_DEFAUT		; ALORS 'HL' CONTIENT LA SOURCE		#
	LD HL, #4000			; SINON VALEUR PAR DEFAUT ET ON FAIT	#
	INC A				; CROIRE QU'IL Y A 1 OU 3 PARAMETRES 	#
					;					#
   IX_PAR_DEFAUT			;					#
	LD E, (HL)			; INITIALISER LES DONNEES		#
	INC HL				;					#
	LD D, (HL)			;					#
	INC HL				;					#
	LD (ADR_ECRAN + 1), DE		; DEPART SUR L'ECRAN INITIALISE		#
	LD E, (HL)			;					#
	INC HL				;					#
	LD D, (HL)			;					#
	INC HL				;					#
	LD (COL_LIG + 1), DE		; LARGEUR ET HAUTEUR INITIALISES	#
	LD E, A				;					#
	LD A, (HL)			; 					#
	INC HL				;					#
	LD (TOKEN_04 + 1), A		; TOKEN INITIALISE			#
	LD A, E				;					#
	LD (ADR_IX + 2), HL		; SOURCE INITIALISEE			#
	DEC A				; SUPPRIMER LE DERNIER PARAMETRE	#
	INC IX				;					#
	INC IX				;					#
; ######################################; CETTE PARTIE EST COPIEE AVEC L'IMAGE	#
DECOMPACTEUR				; SUIVANT L'OPTION AVEC OU SANS DEZIP.	#
					;					#
   ADR_ECRAN	LD HL, #C000		; PAR DEFAUT, MODIF. PAR LES PARAMETRES	#
	DEC A				; REGARDER SI ON VEUT MODIFIER LA	#
	DEC A				; POSITION SUR L'ECRAN DEPUIS LES	#
	JR NZ, INIT_VAR_OK 		; PARAMETRES				#
	LD H, A				; ADAPTER LA POSITION DU CURSEUR POUR	#
	LD L, (IX + 0)			;					#
	LD D, A				; 'DE'=COL 'HL'=LIG			#
	LD E, (IX + 2)			;					#
	CALL #BC11			; AJUSTER 'DE' EN FONCTION DU MODE	#
	ADD A, A			; 'A'=MODE x 2				#
					;					#
   AJUSTE_MODE				;					#
	SLA E				; MULTIPLIER 'DE' PAR 2-MODE0 4-MODE1	#
	RL D				; 8-MODE2 (de 0 a 639)			#
	SRL A				; DIVISER POUR MIEUX MULTIPLIER		#
	JR NZ, AJUSTE_MODE		;					#
	CALL #BC1D			; VECTEUR ADR. ECRAN			#
					;					#
   INIT_VAR_OK				;					#
   ADR_IX	LD IX, #4000		; PAR DEFAUT. (AUTO_MODIFIE)		#
   COL_LIG	LD BC, #50C9		; PAR DEFAUT. AUTO MODIF		#
	DEC C				; SUPPRIMER LE SURPLUS			#
	LD (SOURCE), HL			; SAUVEGARDER LES VARIABLES		#
	LD (LARG_HAUT), BC		;					#
					;					#
   PROG_DECOMP				;					#
	LD A, (IX)			; PRENDRE CHAQUE OCTET			#
	INC IX				;					#
					;					#
   TOKEN_04 CP A, TOKEN			; SI C'EST UN TOKEN			#
	JR Z, OCTET_TOKEN		; FAIRE BOUCLE AVEC 'D' COMME COMPTEUR	#
	LD D, 1				; SINON DEFINIR LA BOUCLE A UN OCTET	#
	LD E, A				; ET CHARGER DANS 'E' L'OCTET		#
	JR INIT_DE			; ALLER VERS LA BOUCLE POUR UN OCTET	#
					; 					#
   OCTET_TOKEN				;					#
	LD E, (IX + 0) 			; RECUPERER LA VALEUR DE L'OCTET 	#
	INC IX				;					#
	LD D, (IX + 0)			; ET LE NOMBRE DE FOIS A REPETER	#
	INC IX				;					#
					; 					#
   INIT_DE				; 					#
	LD A, H				; EN CAS DE DEBORDEMENT, PLUTOT QUE DE	#
	CP A, #C0			; PLANTER L'AMSTRAD, J'AI OPTE POUR NE	#
	JR C, HORS_ECRAN		; PAS ECRIRE DANS LA MEMOIRE <#C000	#
	LD (HL), E			; AFFICHER L'OCTET 			#
	INC HL				; ET PASSER AU SUIVANT, MAIS SI ON	#
	DEC B				; ARRIVE EN FIN DE COLONNE, DESCENDRE	#
	JR NZ, HL_MOINS_UN		; L'ADR_ECRAN D'UNE LIGNE		#
					;					#
HORS_ECRAN				;					#
	DEC C				; JUSQU'A CE QU'IL NE RESTE AUCUNE LIGNE#
	RET Z 				; DANS CE CAS, ON REND LA MAIN		#
	LD HL, (SOURCE)			; SINON ON REVIENT EN DEBUT DE COLONNE	#
	CALL #BC26			; ET ON DESCEND D'UNE LIGNE		#
	LD (SOURCE), HL			; ON SAUVE LE DEBUT DE COLONNE		#
	LD A, (LARG_HAUT + 1)		; ET ON RECUPER LA LARGEUR		#
	LD B, A				; DANS LE REGISTRE 'B'			#
					; 					#
   HL_MOINS_UN				; 					#
	DEC D				; ON DECREMENTE LE NOMBRE D'OCTETS 	#
	JR NZ, INIT_DE			; JUSQU'A CE QUE 'D'=0			#
	JR PROG_DECOMP			; SINON ON POURSUIT LE DECOMPACTAGE	#
					; JUSQU'A CE QUE 'BC'=0			#
	FIN				; FIN DU PROGRAMME A COPIER		#
; ###############################################################################
RSX_ZIPOP				; OPTION AVEC/SANS ET TOKEN		#
	DEC A				;					#
	JR Z, AVEC_SANS			; PARAMETRE TOKEN ABSENT		#
	DEC A				; SI PLUS DE 2 PARAMETRES		#
	JP NZ, ERREUR			; DEHORS				#
	LD A, E				;					#
	LD (TOKEN_01 + 1), A		; MODIFIER LE TOKEN DU TOKEN PAR DEFAUT #
	LD (TOKEN_02 + 1), A		;					#
	LD (TOKEN_03 + 1), A		;					#
	LD (TOKEN_04 + 1), A		;					#
	INC IX				; FAIRE COMME CI LE PARAMETRE TOKEN NI	#
	INC IX				; ETE PAS POUR PASSER AU SUIVANT	#
					;					#
   AVEC_SANS				;					#
	LD A, (IX + 0)			; RECUPERER LA VALEUR AVEC=0 SANS<>0	#
	OR A		 		; ZERO DONC AVEC LE DEZIPPEUR		#
	JR Z, AVEC_LE_DEZIPPEUR		;					#
	LD A, #10			; <>ZERO DONC SANS LE DEZIPPEUR		#
					;					#
   AVEC_LE_DEZIPPEUR			;					#
	LD (AVEC_SANS_DECOMPACTEUR + 1), A ;					#
	RET				;					#
; ###############################################################################
RSX_ZIPLONG				; RECUPERER LA LONGUEUR OBTENUE		#
	DEC A				;					#
	JP NZ, ERREUR			; 1 SEUL PARAMETRE			#
	EX HL, DE			; 'HL'= ADRESSE DE LA VARIABLE		#
	LD DE, (LONG)			; CA PARLE TOUT SEUL			#
	LD (HL), E			;					#
	INC HL				;					#
	LD (HL), D			;					#
	RET				;					#
; ###############################################################################

