; ####################################################################################### 
; # TYPO   -   FONTE DE 93 CARACTERES D'UNE MATRICE DE 4x8 UTILISABLES DANS LES 3 MODEs # 
; # RETROPOKE.CANALBLOG.COM #### Philippe Moulin ##### DEBUT 08/07/2020  MAJ 15/07/2020 #
; # RSX COMPATIBLE AVEC LES TROIS MODES DE L'AMSTRAD ET SUR TOUS LES CPC (464,664,6128)	#
; # RSXs TYPO, DEFTYPO, ENCRE								#
; #######################################################################################
; DECLARATION DES VARIABLES			; #BDF7 - #BE3F ZONE UTILISATEUR LIBRE	#
MATRICE 	EQU #BDF7			; VARIABLE PROVISOIRE 			#
ORG #A000 					; 					#
; #######################################################################################
FIXE_RSX ; IMPLANTATION DES RSX								#
;	LD A, #C9				; EMPECHER D'Y REVENIR 			#
;	LD (FIXE_RSX), A			; POUR EVITER LES PLANTAGES		#
	LD BC, ADR_NOM_RSX			; 'BC' POINTE SUR 2 OCTETS ADR. NOM RSX	#
	LD HL, QUATRE_OCTETS			; 'HL' POINTE SUR 4 OCTETS DE LIBRE	#
	JP #BCD1				; VECTEUR QUI FIXE LES RSX		#
						; 					#
   ADR_NOM_RSX	DW NOM_RSX			; POINTE SUR L'ADRESSE DES NOMS DES RSX #
        	JP RSX_TYPO			; LISTE DES SAUTS VERS LES RSX		#
		JP RSX_DEFTYPO			;					#
		JP RSX_ENCRE			;					#
						;					#
   QUATRE_OCTETS DS 4				; EMPLACEMENT DES 4 OCTETS RESERVES	#
   NOM_RSX	STR "TYPO"			; LISTE DES NOMS DES RSX		#
		STR "DEFTYPO"			; CHAQUE NOM DOIT FINIR AVEC BIT_8 A 1	#
		STR "ENCRE"			; WINAPE LE FAIT AUTOMATIQUEMENT	#
		DB 00				; LA LISTE DOIT FINIR PAR UN OCTET ZERO #
; #######################################################################################
RSX_TYPO ; |TYPO, @a$ 				; A$ DOIT ETRE DECLARE AVANT UTILISATION#
	DEC A					; VERIFIER LE NOMBRE DE PARAMETRE	#
 	RET NZ					; ERREUR IL NE FAUT QU'UN PARAMETRE	#
	DEC A 					; EQUIVAUT A ('A' = 255)		#
	CALL #BBA5				; RECHERCHER L'ADRESSE DE LA MATRICE	#
	LD (HL), 0				; METTRE LA 1ere LIGNE/8 A ZERO		#				
	INC HL					; ET PASSER SUR LA 2eme LIGNE/8		#
	LD (MATRICE), HL			; MEMORISER L'ADRESSE DE TRAVAIL	#
 	EX HL, DE				; 'HL'= ADR. DU DESCRIPTEUR DE CHAINE	#
	LD A, (HL)				; 'A'= NOMBRE DE CARACTERE DE LA CHAINE	#
	OR A					; SI LA CHAINE EST VIDE	ON SORT		#
	RET Z					;					#
	LD B, A					; 'B' SERA UTILISE POUR DECOMPTER LA	#
	INC HL					; LONGUEUR DE LA CHAINE			#
	LD E, (HL)				;					#
	INC HL					;					#
	LD D, (HL)				; 'DE' POINTE SUR LE PREMIER CARACTERE	#
   PUSH DE					; QUE L'ON TRANSMET AU REGISTRE 'IX'	#
   POP IX					;					#
						;					#
    FAIRE_TOUTE_LA_CHAINE			;					#
	LD IY, (MATRICE)			; 'IY' POINTE SUR LA MATRICE 8x8 + 1	#
	LD A, (IX)				; 'A' CONTIENT LE 1er CARACTERE	DE LA	#
	INC IX					; CHAINE				#
	CALL MATRICE4x8_DANS_HL			; CALCULER L'ADR. DE LA TABLE TYPO 4x8	#
	EX HL, DE				; ET PASSER L'ADRESSE DANS 'DE'		#
	LD A, (IX)				; 'A' CONTIENT LE CARACTERE SUIVANT	#
	INC IX					;					#
	DEC B					; ON DECREMENTE LE NOMBRE DE CACARTERE 	#
	JR NZ, NB_PAIR				; SI IL N'Y A QU'UN CARACTERE FINAL	#
	XOR A					; LE SUIVANT EST REMPLACE PAR UN ESPACE	#
	INC B					; 					#
						;					#
    NB_PAIR					;					#
	CALL MATRICE4x8_DANS_HL			; CALCULER L'ADR. DU 2eme CARACTERE 4x8	#
   PUSH BC					; ON A LES DEUX ADR. DES CARACTERES QUI	#
						; FAUT UNIR POUR N'EN FORMER PLUS QU'UN	#
	LD B, 3					;					#
    FAIRE_3OCTETS				; UN CARACTERE EST CODE SUR 3 OCTETS	#
	LD A, (DE)				; POUR UNIR LES 2 CARACTERES, IL FAUT	#
	AND #F0					; PRENDRE LE POIDS FORT DU 1er PUIS 	#
	LD C, A					; REMPLACER LE POIDS FORDS DU 2eme PAR	#
	LD A, (HL)				; LE POIDS FAIBLE DE L'OCTET OBTENU	#
	AND #F0					; ET ADDITIONNER LES DEUX		#
	RRA					; PAS TROUVE PLUS SIMPLE POUR DESCENDRE	#
	RRA					; LE POIDS FORT EN POIDS FAIBLE		#
	RRA					;					#
	RRA					;					#
	ADD A, C				; ON AJOUTE LE POIDS (FORT ET FAIBLE)	#
	LD (IY), A				; ET ON L'INSCRIT DANS LA MATRICE 8x8	#
	INC IY					; IL FAUT S'OCCUPER DES DEUX POIDS 	#
	LD A, (DE)				; FAIBLES 				#
	AND #0F					; POIDS FAIBLE DU 1er CARACTERE 	#
	ADD A, A				; QUE L'ON MET EN POIDS FORT POUR LE	#
	ADD A, A				; 2eme OCTETS				#
	ADD A, A				; PAS TROUVE PLUS SIMPLE NON PLUS	#
	ADD A, A				;					#
	LD C, A					;					#
	LD A, (HL)				; ON PREND LE POIDS FAIBLE DU 2eme	#
	AND #0F					; CARACTERE				#
	ADD A, C				; L'ADDITION FORME LE 2eme OCTET	# 
	LD (IY), A				; QUE L'ON INSCRIT DANS LA MATRICE 8x8	#
	INC IY					; ON REMET LES POINTEURS A JOUR		#
	INC HL					;					#
	INC DE					;					#
	DJNZ, FAIRE_3OCTETS			; ET ON RECOMMENCE 3 FOIS		#
	XOR A					; IL NE RESTE PLUS QU'A L'AFFICHER	#
	LD (IY), A				; ON EFFACE LA 8eme LIGNE DU CARACTERE	#
	DEC A					; ('A'=0 'A'=255)			#
	CALL #BBFC				; VECTEUR GRAPHIQUE AFFICHE 'A'		#
	POP BC					; ON RECUPERE LE NOMBRE DE CARACTERE	#
	DJNZ, FAIRE_TOUTE_LA_CHAINE		; ET ON RECOMMENCE JUSQU'AU DERNIER	#
	RET					; CARACTERE DE LA CHAINE		#
; #######################################################################################
RSX_DEFTYPO ; A$="x=F99F66F9" |DEFTYPO, @A$ 	; REDEFINI LES 6 LIGNES DU SYMBOLE 'x'	#
	DEC A					;					#
	RET NZ					; SI LE NOMBRE DE PARAMETRE EST ERRONE	#
	EX HL, DE				; 'HL'= ADR. DU DESCRIPTEUR DE CHAINE	#
	LD A, (HL)				; 'A'= NOMBRE DE CARACTERE DE LA CHAINE	#
	CP A, 9					; ON REGARDE LE NOMBRE DE CARACTERE QUI	#
	RET NC					; DOIT ETRE DE 8 SINON ON SORT		#
	INC HL					;					#
	LD E, (HL)				;					#
	INC HL					;					#
	LD D, (HL)				; 'DE' POINTE SUR LE PREMIER CARACTERE	#
	LD B, 3					; 'B' SERVIRA DE BOUCLE			#
	LD A, (DE)				; 'A' CONTIENT LE CARACTERE A REDEFINIR #
	INC DE					; IGNORER LE 2eme CARACTERE "="		#
	INC DE					; 					#
	CALL MATRICE4x8_DANS_HL			; 'HL' POINTE SUR LA MATRICE A REDEFINIR#
						;					#
    SYMBOL_3_OCTETS				; IL FAUT TRANSFORMER LES 6 VALEURS	#
	LD A, (DE) 				; HEXADECIMALES EN 3 OCTETS 		#
	INC DE					;					#
	CALL TRANS_HEXA				; TRADUIT LE CARACTERE HEXADECIMAL EN	#
	ADD A, A				; NOMBRE DECIMAL DE 0 A 15		#
	ADD A, A				; ON AJUSTE AU POIDS HAUT DE L'OCTET	#
	ADD A, A				; "XXXX...."				#
	ADD A, A				; IL FAUT 2 VALEURS HEXA. POUR OBTENIR 	#
	LD C, A					; UN OCTET DE 0 A 255			#
	LD A, (DE)				;					#
	INC DE					; ON PREND LE DEUXIEME CARACTERE HEXA.	#
	CALL TRANS_HEXA				; 	 				#
	ADD A, C				; 1er CARACTERE (POIDS HAUT DE L'OCTET)	#
	LD (HL), A				; 2eme CARACTERE (POIDS BAS DE L'OCTET)	#
	INC HL					; ET ON FAIT LES 3 OCTETS DU CARACTERE	#
	DJNZ, SYMBOL_3_OCTETS			;					#
	RET					;					#
; #######################################################################################
RSX_ENCRE ; |ENCRE, PEN [,PAPER] 		; DEFINI LES ENCRES GRAPHIQUES		#
	DEC A					; ON REGARDE SI ON A 1 SEUL PAREMETRE	#
	JR Z, PEN				; 					#
	DEC A					; SINON ON REGARDE SI ON EN A 2		#
	RET NZ					; ON SORT SI CE N'EST PAS LE CAS	#
						; 					#
    PAPER					; 					#
	LD A, E					; SI > 15				#
	CALL #BBE4				; VECTEUR GRAPHIC_PAPER			#
	LD E, (IX + 2)				; ET ON SIMULE POUR 1 SEUL PARAMETRE	#
						;					#
    PEN						;					#
	LD A, E					;					#
	CALL #BBDE				; VECTEUR GRAPHIC_PEN			#
	RET					;					#
; #######################################################################################
; SOUS ROUTINE MATRICE4x8_DANS_HL [CE> 'A' = CARACTERE A TROUVER) 			#
MATRICE4x8_DANS_HL				; FAIRE CORRESPONDRE LE CARACTERE	#
	LD HL, DEF_TYPO				; 'HL' POINTE SUR LE CARACTERE " "	# 
	SUB A, #20 				; ON AJUSTE LE NUMERO DU CARACTERE	#
	RET Z					; SI C'EST UN ESPACE, 'HL' EST OK	#
	CP A, #5D				; ON REGARDE SI LE CARACTERE EST TROUVE #
	RET NC					; NON ALORS 'HL' POINTE DEJA SUR " "	#
						;					#
	CALCUL_MATRICE				; SINON IL FAUT CALCULER L'ADRESSE DU	#
	INC HL					; CARACTERE ET COMME CHAQUE CARACTERE	#
	INC HL					; OCCUPE 3 OCTETS			#
	INC HL					; ON DEPLACE 'HL' DE 3 OCTETS 		#
	DEC A					; JUSQU'A TROUVER LE BON CARACTERE	#
	JR NZ, CALCUL_MATRICE			; 					#
	RET 					;					#
; #######################################################################################
TRANS_HEXA ; SOUS ROUTINE QUI TRADUIT LE CARACTERE HEXADECIMAL EN NOMBRE DECIMAL	#
	CP A, "G"				; SI 'A'<"F"				#
	JR C, HEXA_MINUSCULE			; SI ON EST EN MINUSCULE, ON AJUSTE	# 
	SUB A, #20				; POUR LE TRANSFORMER EN MAJUSCULE	#
						;					#
    HEXA_MINUSCULE				;					#
	CP A, ":" 				; SI 'A'= de "A" a "F"			#
	JR C, ENTRE_0ET9			; IL FAUT AJUSTER POUR QUE CA 		#
	SUB A, 7				; CONTINU AU DESSUS DE "9"		#
						;					#	
    ENTRE_0ET9					;					#
	SUB A, 48				; ON AJUSTE LE TOUT POUR QUR LE 	#
	CP A, 16				; CARACTERE "0" CORRESPONDE A ZERO	#
	RET C					; SI LE CHIFFRE EST BON (0 a 15)	#
	XOR A					; SINON ON LE TRANSFORME EN ZERO	#
	RET					;					#
; #######################################################################################
DEF_TYPO ; 		 59 SYMBOLES 4x8 PREDEFINIS
; ##### 93 CARACTERES * 3 OCTETS = 279 OCTETS #####
DB #00,#00,#00 ; " " 
DB #66,#66,#06 ; "!"
DB #AA,#00,#00 ; """
DB #AF,#A5,#F5 ; "#"
DB #23,#67,#36 ; "$"
DB #09,#36,#C9 ; "%"
DB #69,#6B,#A5 ; "&"
DB #66,#C0,#00 ; "'"
DB #24,#44,#42 ; "("
DB #42,#22,#24 ; ")"
DB #0A,#E4,#EA ; "*"
DB #04,#4E,#44 ; "+"
DB #00,#06,#6C ; "," 
DB #00,#E0,#00 ; "-" 
DB #00,#06,#60 ; "." 
DB #22,#44,#88 ; "/"
DB #EA,#AE,#EE ; "0"
DB #4C,#44,#EE ; "1" 
DB #E2,#E8,#EE ; "2" 
DB #E2,#62,#EE ; "3"
DB #88,#AE,#E2 ; "4"
DB #E8,#E2,#EE ; "5"
DB #E8,#EA,#EE ; "6"
DB #E2,#64,#CC ; "7"
DB #EA,#EA,#EE ; "8"
DB #EA,#E2,#EE ; "9"
DB #CC,#0C,#C0;; ":"
DB #66,#06,#6C ; ";"
DB #24,#84,#20 ; "<"
DB #00,#60,#60 ; "="
DB #84,#24,#80 ; ">"
DB #EA,#64,#04 ; "?"
DB #40,#6A,#A6 ; (a accent)
DB #EE,#EA,#EA ; A
DB #CE,#AC,#AE ; B
DB #EE,#E8,#8E ; C
DB #CE,#EA,#AC ; D
DB #EE,#8C,#8E ; E
DB #EE,#8C,#88 ; F
DB #EE,#8B,#AE ; G
DB #AA,#EE,#AA ; H
DB #EE,#E4,#4E ; I
DB #EE,#2A,#E4 ; J
DB #8A,#EC,#EA ; K
DB #88,#8A,#EE ; L
DB #AE,#EE,#AA ; M
DB #EE,#EA,#AA ; N
DB #EE,#EA,#AE ; O
DB #EE,#EA,#E8 ; P
DB #EE,#EA,#BF ; Q
DB #EE,#AC,#EA ; R
DB #EE,#8E,#2E ; S
DB #EE,#E4,#44 ; T
DB #AA,#AE,#EE ; U
DB #AA,#EE,#44 ; V
DB #AA,#EE,#EA ; W
DB #AE,#44,#EA ; X
DB #AA,#EE,#2E ; Y
DB #EE,#24,#8E ; Z
DB #E8,#88,#8E ; [
DB #44,#22,#11 ; \
DB #E2,#22,#2E ; ]
DB #4E,#44,#44 ; (fleche))
DB #00,#00,#0F ; (trait)
DB #21,#00,#00 ; (barre)
DB #00,#6A,#A6 ; a
DB #88,#CA,#AC ; b
DB #00,#68,#86 ; c
DB #22,#6A,#A6 ; d
DB #06,#AC,#86 ; e
DB #06,#8C,#88 ; f
DB #04,#AE,#26 ; g
DB #88,#CA,#AA ; h
DB #40,#C4,#4E ; i
DB #20,#62,#A4 ; j
DB #88,#AA,#CA ; k
DB #0C,#44,#4E ; l
DB #00,#AE,#EA ; m
DB #00,#CA,#AA ; n
DB #00,#4A,#A4 ; o
DB #CA,#AC,#88 ; p
DB #04,#AA,#42 ; q
DB #00,#CA,#CA ; r
DB #00,#6C,#2C ; s
DB #08,#C8,#A4 ; t
DB #00,#AA,#A6 ; u
DB #00,#AA,#E4 ; v
DB #00,#AA,#EA ; w
DB #00,#A4,#4A ; x
DB #00,#A6,#2C ; y
DB #0E,#24,#8E ; z
DB #40,#6A,#C6 ; (e accent)
DB #40,#AA,#A6 ; (u accent)
FIN

