; #######################################################################################
; # RETROPOKE.CANALBLOG.COM #### Philippe Moulin ##### DEBUT 06/06/2020  MAJ 10/07/2020 #
; # RSX COMPATIBLE AVEC LES TROIS MODES DE L'AMSTRAD ET SUR TOUS LES CPC (464,664,6128)	#
; #######################################################################################
;;# TEXTE$="MON TEXTE": |SYMBOLXXL, @TEXTE$						#
; # SYMBOLLXXL EST UNE COMMANDE RSX QUI AFFICHE DIRECTEMENT DES SYMBOLES DEFINIS DANS 	#
; # UNE CHAINE DE CARACTERES. CHAQUE SYMBOLE EST REPRESENTE PAR UNE SUITE DE CHIFFRES   #
; # HEXADECIMAUX. DES TOKENs PEUVENT ETRE UTILISES POUR EFFECTUER DIVERS ACTIONS.	# 
; # - TOKEN [,] = SEPARATION ENTRE DEUX SYMBOLE (exemple "FF818181FF,817E7E7E81")	#
; # - TOKEN [;] = POSITIONNE LE PROCHAIN SYMBOLE EN DESSOUS DU PREMIER			#
; # - TOKEN [.] = REPETE LE SYMBOLE PRECEDENT						#
; # - TOKEN [ ] = RIEN (PERMET JUSTE DE MIEUX SI RETROUVER)				#
; # - TOKEN [S] = SELECTIONNE LE STYLO (exemple "FF8181FF S4 007E7E00" 			#
; # CHAQUE GROUPES HEXADECIMAUX QUI DEFINISSENT LE SYMBOLE DOIT COMPORTER AU MINIMUM	# 
; #  		DEUX CHIFFRES (exemple 'FF' = BON) (exemple 'F' = ERREUR)		#
; # POUR INSERRER UN SYMBOLE VIDE, IL SUFFIT DE LE DEFINIR PAR '00' LE RESTE DU SYMBOLE #
; # 		SERA AUTOMATIQUEMENT COMPLETE PAR DES ZEROS				# 
; # CHAQUE SYMBOLE SERA AFFICHE A LA SUITE DU PRECEDENT SAUF SI VOUS UTILISEZ 		#
; #		LE TOKEN ';' QUI PERMET DE DESCENDRE D'UNE LIGNE LE CURSEUR		#
; # LE DERNIER CARACTERE DE LA CHAINE NE DOIT PAS ETRE UN TOKEN				#
; # EN CAS D'ERREUR DANS LA CHAINE, UN BEEP SERA EMIS					# 
; #######################################################################################
LOCALISE	EQU #BDF7			; SAUVEGARDE DE LA POSITION DU CURSEUR	#
MATRICE 	EQU #BDF9			; ADRESSE DE LA MATRICE DU SYMBOLE 255	#
FIXE_RSX					;					#
ORG #A460					;					#
; ########## DECLARATION RSX ##################	;					#
	LD A, #C9				; ON EMPECHE DE LANCER PLUSIEURS FOIS   #
	LD (FIXE_RSX), A			; 'FIXE_RSX' POUR EVITER DES PLANTAGES 	#
	LD HL, QUATRE_OCTETS			; 'HL' POINTE SUR 4 OCTETS VIDE		#
	LD BC, ADR_NOM_RSX			; 'BC' POINTE SUR 2 OCTETS CONTENANT 	#
						; L'ADRESSE DES NOMS DES RSX		#
	JP #BCD1				; VECTEUR QUI FIXE LES RSX		#
						;					#
   ADR_NOM_RSX	DW NOM_RSX			; POINTE SUR L'ADRESSE DES NOMS DES RSX #
        JP RSX_SYMBOLXXL			; LISTE DES SAUTS VERS LES RSX		#
						;					#
   NOM_RSX	STR "SYMBOLXXL"			; LISTE DES NOMS DONNES AUX RSX		#
	DB 00					; LA LISTE DOIT FINIR PAR UN OCTET ZERO #
						;					#
   QUATRE_OCTETS DS 4				; EMPLACEMENT DES 4 OCTETS RESERVES	#
RSX_SYMBOLXXL					;					#
; ########## PROGRAMME PRINCIPAL ##############	;					#
	DEC A					; REGARDER SI IL N'Y A QUE 1 PARAMETRE 	#
	JP NZ, ERREUR				; SINON ERREUR (BEEP)			#
	DEC A 					; 'A' = 255				#
	CALL #BBA5				; RECHERCHER L'ADRESSE DE LA MATRICE	#
	LD (MATRICE), HL			; DU SYMBOLE 255			#
	CALL #BB78				; RELEVER LA POSITION DU CURSEUR	#
	LD (LOCALISE), HL			; ET LA MEMORISER			#
	EX HL, DE				; 'HL'= ADR. DU DESCRIPTEUR DE CHAINE	#
	LD A, (HL)				; 'A'= NOMBRE DE CARACTERE DE LA CHAINE	#
	OR A					; SI LA CHAINE EST VIDE			#
	JP Z, ERREUR				; ON SORS AVEC LE BEEP ERREUR		#
	INC HL					;					#
	LD E, (HL)				;					#
	INC HL					;					#
	LD D, (HL)				; 'DE' POINTE SUR LE PREMIER CARACTERE	#
	LD C, A					; 'C' SERVIRA DE BOUCLE			#
						;					#
   FAIRE_TOUTE_LA_CHAINE			;					#
	LD HL, (MATRICE)			; ON UTILISE LA MATRICE DU CARACTERE	#
	LD B, 8					; 255 POUR DEFINIR CHAQUE SYMBOLE	#
						;					#
   LIRE_CARACTERE				; CHARGER DANS 'A' CHACUN DES CARACTERES#
	LD A, (DE)				; QUE COMPORTE LA CHAINE		#
	INC DE					; ET PASSER AU SUIVANT			#
		CP A, "."			; FAUT'IL REPETER LE SYMBOLE ?		#
		JR NZ, TOKEN_PRINT_2x		; NON					#
		CALL AFFICHER_LE_SYMBOLE	; OUI ALORS ON AFFICHE LE SYMBOLE	#
		CALL MATRICE_PLEINE		; ET ON RE-AFFICHE LE MEME SYMBOLE	#
		DEC C				; ON VERIFIE SI ON EST EN FIN DE CHAINE #
		RET Z				;					#
		JR FAIRE_TOUTE_LA_CHAINE	; ET ON PASSE AU SYMBOLE SUIVANT	#
						;					#
	TOKEN_PRINT_2x				;					#
	DEC C					; 'C' = NOMBRE DE CARACTERE - 1		#
	JP Z, ERREUR				; IL FAUT DEUX CARACTERES HEXADECIMAL	#
		CP A,"S"			; FAUT'IL CHANGER DE STYLO		#
		JR NZ, TOKEN_VIRGULE		; NON					#
		CALL AFFICHER_LE_SYMBOLE	; OUI ALORS ON AFFICHE LE SYMBOLE	#
		LD A, (DE)			; OUI, ON RECUPERE LA VALEUR HEXA QUI	#
		INC DE				; EST APRES LE CARACTERE "S"		#
		DEC C				; ET ON DEC LE NOMBRE DE CARACTERE	#
		JP Z, ERREUR			; INTERDIT EN FIN DE CHAINE		#
		CALL HEXA			; TRADUIRE LE STYLO EN DECIMAL		#
	      PUSH HL				; LE VECTEUR PEN ECRASE LE REGISTRE 'HL'#
		CALL #BB90			; VECTEUR PEN				#
	      POP HL				;					#
		JR FAIRE_TOUTE_LA_CHAINE	; PASSER AU SYMBOLE SUIVANT		#
						;					#
   TOKEN_VIRGULE				;					#
		CP A, ","			; EST-CE QU'ON DOIT PASSER AU SUIVANT	#
		JR NZ, TOKEN_CHRS_13		; NON					#
		CALL AFFICHER_LE_SYMBOLE	; OUI, ON AFFICHE LE SYMBOLE		#
		JR FAIRE_TOUTE_LA_CHAINE	; ET ON PASSE AU CARACTERE SUIVANT	#
						;					#
	TOKEN_CHRS_13 				;					#	
		CP A, ";"			; AFFICHER LE SYMBOLE ET DESCENDRE ?	#
		JR NZ, TOKEN_ESPACE		; NON					#
		CALL AFFICHER_LE_SYMBOLE	; OUI, ON AFFICHE LE SYMBOLE		#
	      PUSH HL				;					#
		LD HL, (LOCALISE)		; ON REVIENT SUR LA PREMIERE POSITION 	#
		INC L				; DU CURSEUR ET ON DESCEND D'UNE LIGNE	#
		LD (LOCALISE), HL		; ON MEMORISE LA NOUVELLE POSITION	#
		CALL #BB75			; ET ON EFFECTUE UN LOCATE		#
	     POP HL				;					#
		JR FAIRE_TOUTE_LA_CHAINE	; ET ON PASSE AU CARACTERE SUIVANT	#
						; ET ON PASSE AU CARACTERE SUIVANT	#		
	TOKEN_ESPACE				;					#
		CP A, " "			; LE CARACTERE ESPACE EST SIMPLEMENT 	#
		JR Z, LIRE_CARACTERE		; IGNORE, ON PASSE AU SUIVANT		#
						; ET ON PASSE AU CARACTERE SUIVANT	#
   HEXADECIMAL					; 					#
; ########## CE N'EST PAS UN TOKEN ############ ;					#
	CALL HEXA				; SOUS ROUTINE DE TRANSLATION EN HEXA.	# 
	ADD A, A				; IL FAUT PLACER LA VALEUR HEXADECIMAL	#
	ADD A, A				; SUR LA GAUCHE (POIDS FORT DE L'OCTET) #
	ADD A, A				;					#
	ADD A, A				;					#
	LD (VALEUR + 1), A			; ON LE MEMORISE 			#
	LD A, (DE)				; ON PASSE AU DEUXIEME CARACTERE DE LA	#
	CALL HEXA				; VALEUR HEXADECIMAL ET ON LE TRADUIT	# 
   	VALEUR 	ADD A, #00			; ON ADDITIONNE LES DEUX CARACTERES QUI	#			
	LD (HL), A				; COMPOSENT LA VALEUR FINALE DE L'OCTET	#
	INC HL					; 					# 
	INC DE					;					#
	DEC C					; ON REGARDE SI LA CHAINE EST TERMINEE	#  
	JP Z, AFFICHER_LE_SYMBOLE		; OUI, ALORS ON AFFICHE LE SYMBOLE	#
	DJNZ, LIRE_CARACTERE			; NON DONC ON CONTINU JUSQU'A LA FIN	#
	CALL AFFICHER_LE_SYMBOLE		; D'UN SYMBOLE SOIT 8 OCTETS PUIS ON 	#
	JR FAIRE_TOUTE_LA_CHAINE		; L'AFFICHE ET ON RECOMMENCE LA LECTURE #
	RET					; JUSQU'A LA FIN LA CHAINE		#
						;					#
AFFICHER_LE_SYMBOLE				;					#
; ########## SOUS ROUTINE AFFICHER LE SYMBOLE # ;					#
	LD A, B					; AVANT D'AFFICHER LE SYMBOLE, IL FAUT	#
	CP A, 8					; REGARDER SI ON A DEFINI LES 8 OCTETS	#
	RET Z					; SINON IL FAUT REMPLIR LES OCTETS 	#
	OR A					; RESTANTS AVEC DES ZEROS		#
	JR Z, MATRICE_PLEINE			; OUI ON A DEFINI LES 8 OCTETS		#
	XOR A					; NON, 'A' = 0				#
						;					#
   VIDER_LA_MATRICE				;					#
	LD (HL), A				;					#
	INC HL					; ON TERMINE TOUTE LA MATRICE		#
	DJNZ, VIDER_LA_MATRICE			; JUSQU'AU DERNIER OCTET		#
						;					#
   MATRICE_PLEINE				; UNE FOIS TERMINEE,			#
	XOR A					; ON CHARGE 'A' AVEC LA VALEUR 255	#
	DEC A					; XOR A ('A'=0) DEC A ('A'=255) 	#
	CALL #BB5A				; PLUS RAPIDE QUE LD A, #FF		#
	RET					; PUIS ON AFFICHE LE SYMBOLE 255	#
						;					#
HEXA						;					#
; ########## SOUS ROUTINE CONVERTION HEXADECIMAL;					#
	CP A, 48				; SI 'A'<"0"				#
	JP C, ERREUR				; LE CARACTERE N'EST PAS RECONNU	#
	CP A, "g"				; SI 'A' >"f"				#
	JP NC, ERREUR				; LA CHAINE COMPORTE DES ERREURS	#
	CP A,":"				; SI 'A' >="0" ET QUE 'A' <="9"		#
	JP C, DE_0A9				; ALORS ON CONTINU LES CALCULS		#
	CP A, "A"				; SI 'A'>"9" ET QUE 'A' <'A'		#
	JP C, ERREUR				; LE CARACTERE N'EST PAS RECONNU	#
						;					#
   DE_0A9					; LE CARACTERE EST RECONNU		#
	SUB A, 48 				; ON DEDUIT POUR QUE LES CARACTERES	#
	CP A, #0A 				; "01234556789" CORRESPONDENT DE 0 A 9	# 
	RET C					; SI LA VALEUR <10 ALORS ON A TERMINE	#
	SUB A, 7				; IL FAUT QUE LES CARACTERES "ABCDEF"	#
	CP A, #10				; CORRESPONDENT A LA VALEUR DE 11 A 15	#
	RET C					; ET SI C'EST LE CAS, ON EN A TERMINE	#
	SUB A, 32 				; IL FAUT QUE LES CARACTERES "abcdef"	#  
	CP A, #10				; CORRESPONDENT A LA VALEUR DE 11 A 15	#
	RET C					; ET ON TERMINE, SINON ERREUR BEEP	#
						;					#
ERREUR						;					#
; ########## TRAITEMENT DES ERREURS ########### ;					#
	LD A, 7					; LE BEEP S'OBTIENT EN AFFICHANT	#
	CALL #BB5A				; LE CARACTERE "7"			#
	RET					; 					#
; #######################################################################################
